function [] = movie_selfmade_pca( PC_data_for_vid,EVactivity_TrialSubj_PC_vid,vid_trial,vid_subj, Title, setting_cell)
%MOVIE_SELFMADE Summary of this function goes here
%   Detailed explanation goes here

%% ****** Read in settings ******
eigenvaluemovie         = setting_cell{1}; % yes or no
x_y_z_setting           = setting_cell{2};
coloring_option         = setting_cell{3};
PC_components_movie     = setting_cell{4};
PC_per_figure_movie     = setting_cell{5};
PathVid                 = setting_cell{6};
dimension_video         = setting_cell{7};
run_throughs            = setting_cell{8};
amplifications_used     = setting_cell{9};
skipFrames              = setting_cell{10};
TransformOption         = setting_cell{11};


% Extra options
only_ExtremVis = 0;
ExtPosFig = 0;


LinewidthPlots = 1; % Do not set higher than 2! Dots begin to dissipate into stars!
if ExtPosFig == 1
    fprintf('\nExtremal Positioning figure is created after movie!\n')
    msgbox('Extremal Positioning figure is created after movie!')
end
if dimension_video == 3
    fprintf('\n3-D video option is chosen!')
    msgbox('3-D video option is chosen!')
end



%% ****** Defining parameters ******
if vid_subj == 0 || vid_trial == 0 % Visualization option
    vid_trial = 1;% PC visualization is a 1x1xPC cell
    vid_subj = 1; % PC visualization is a 1x1xPC cell
    VidVis = 1; % Enable the visualization - Skipframes deactivated!!
    PathVid = fullfile(PathVid, 'PM visualization');
    if eigenvaluemovie == 1;
        eigenvaluemovie = 0;
        msgbox('Eigenvalues disabled for PM visualization!')
    end
else
    VidVis = 0;
    PathVid = fullfile(PathVid, 'PM subject visualization');
end

A = exist(PathVid, 'dir');
if A == 7
else
    mkdir(PathVid);
end

ende_video = size(PC_data_for_vid{vid_trial,vid_subj, PC_components_movie(1)},1); % Nr of rows of the data = length of timeline (all PCs equal)
n_Markers = size(PC_data_for_vid{vid_trial,vid_subj, PC_components_movie(1)},2)/3;


if VidVis ~= 1 && skipFrames ~= 1
    fprintf('\n        Skip Frames == %d (In "movie_selfmade_pca")', skipFrames)
    msgbox(sprintf('Skip Frames == %d (In "movie_selfmade_pca")', skipFrames))
else
    skipFrames = 1;
end


LengthLimit = 5000; 
if ende_video > LengthLimit
    fprintf('\n        Video length truncated to %d Datapoints', LengthLimit)
    msgbox(sprintf('Video length limited to %d Datapoints in "movie_selfmade_pca". Follow this message to change setting', LengthLimit))
    ende_video = LengthLimit;
end




%% Transformation back to carthesian coordinates
if TransformOption{1,1}
    fprintf('\n\n        Coordinates transformed back to carthesian (for videos only)!');
    for pc = PC_components_movie
        [PC_data_for_vid{vid_trial,vid_subj,pc}, ~] = optionsTransformData(PC_data_for_vid{vid_trial,vid_subj,pc}, TransformOption{1,2}, 2); % 2: Back transform to Cartesian coordinates
    end
else

end
fprintf('\n')





%% ****** Getting the axes right ******
permutation_vector = 1:n_Markers*3;
if x_y_z_setting == 1 % nothing
    fprintf('\n        Axes setting: %d (x,y,z) = (1,2,3)', x_y_z_setting)
elseif x_y_z_setting == 2 % x,y are switched!
    for TimePoint = [1:n_Markers]*3
        permutation_vector([TimePoint-2, TimePoint-1]) = permutation_vector([TimePoint-1, TimePoint-2]);
    end
    fprintf('\n        Axes setting: %d (x,y,z) = (2,1,3)', x_y_z_setting)
elseif x_y_z_setting == 3
    for TimePoint = [1:n_Markers]*3
        permutation_vector([TimePoint-1, TimePoint]) = permutation_vector([TimePoint, TimePoint-1]);
    end
    fprintf('\n        Axes setting: %d (x,y,z) = (1,3,2)', x_y_z_setting)
elseif x_y_z_setting == 4
    for TimePoint = [1:n_Markers]*3
        permutation_vector([TimePoint, TimePoint-2, TimePoint-1]) = permutation_vector([TimePoint-2, TimePoint-1, TimePoint]);
    end
    fprintf('\n        Axes setting: %d (x,y,z) = (2,3,1)', x_y_z_setting)
elseif x_y_z_setting == 5
    for TimePoint = [1:n_Markers]*3
        permutation_vector([TimePoint-1, TimePoint, TimePoint-2]) = permutation_vector([TimePoint-2, TimePoint-1, TimePoint]);
    end
    fprintf('\n        Axes setting: %d (x,y,z) = (3,1,2)', x_y_z_setting)
elseif x_y_z_setting == 6
    for TimePoint = [1:n_Markers]*3
        permutation_vector([TimePoint-2, TimePoint]) = permutation_vector([TimePoint, TimePoint-2]);
    end
    fprintf('\n        Axes setting: %d (x,y,z) = (3,2,1)', x_y_z_setting)
else %% SORTING OPTIONS MUST BE ADDED! THE INPUT MUST BE IN FORM [X,Y,Z] X LEADING TO SAGITTAL VIEW; Y LEADING TO FRONTAL VIEW
    msgbox('This x_y_z_setting does not exist!', 'Error', 'Error')
    error('This x_y_z_setting does not exist!')
end
%

% Flip the coordinates to coincide with selected axes
for pc = PC_components_movie
    PC_data_for_vid{vid_trial,vid_subj,pc} = PC_data_for_vid{vid_trial,vid_subj,pc}(:,permutation_vector);
end

% Sagittal plot is x-z
% Frontal  plot is y-z






%% ****** Load in Coloring option ******
[ColorOptionsCell, ~] = optionsColoringVids(coloring_option, n_Markers);
nr_plot_lines = size(ColorOptionsCell, 2);




%% Preparing pc - loop index
pc_loop_index = ceil(length(PC_components_movie)/PC_per_figure_movie);


%% ****** Loopstart to plot the selected PCs ******
fExtPos = gobjects(1, pc_loop_index);
for pcL = 1:pc_loop_index
    if pcL == pc_loop_index && mod(length(PC_components_movie),PC_per_figure_movie) ~= 0
        PcIdxNow = PC_per_figure_movie*(pcL-1)+1:length(PC_components_movie); % Must be before changing PC_per_fig_movie
        PC_per_figure_movie = mod(length(PC_components_movie),PC_per_figure_movie); % has to be adapted for last runthrough!
    else
        PcIdxNow = (pcL-1)*PC_per_figure_movie+1:PC_per_figure_movie*pcL;
    end
    PCsPlotNow = PC_components_movie(PcIdxNow);


    
    
    % Angle of view
    az = 10; % Frontal
    el = 10; % Slight elevation
    
    %     Determine limits!
    
    x_lim_max_mov = max(PC_data_for_vid{vid_trial,vid_subj,PCsPlotNow(1)}(1,[1:n_Markers]*3-2));
    x_lim_min_mov = min(PC_data_for_vid{vid_trial,vid_subj,PCsPlotNow(1)}(1,[1:n_Markers]*3-2));
    y_lim_max_mov = max(PC_data_for_vid{vid_trial,vid_subj,PCsPlotNow(1)}(1,[1:n_Markers]*3-1));
    y_lim_min_mov = min(PC_data_for_vid{vid_trial,vid_subj,PCsPlotNow(1)}(1,[1:n_Markers]*3-1));
    z_lim_max_mov = max(PC_data_for_vid{vid_trial,vid_subj,PCsPlotNow(1)}(1,[1:n_Markers]*3));
    z_lim_min_mov = min(PC_data_for_vid{vid_trial,vid_subj,PCsPlotNow(1)}(1,[1:n_Markers]*3));

    for TimePoint=1:skipFrames:ende_video % ****** Loopstart for Length of video ******
        for j = 1:PC_per_figure_movie
            x_lim_max_mov = max(x_lim_max_mov, max(PC_data_for_vid{vid_trial,vid_subj,PCsPlotNow(j)}(TimePoint,[1:n_Markers]*3-2)));
            y_lim_max_mov = max(y_lim_max_mov, max(PC_data_for_vid{vid_trial,vid_subj,PCsPlotNow(j)}(TimePoint,[1:n_Markers]*3-1)));
            z_lim_max_mov = max(z_lim_max_mov, max(PC_data_for_vid{vid_trial,vid_subj,PCsPlotNow(j)}(TimePoint,[1:n_Markers]*3)));
            
            x_lim_min_mov = min(x_lim_min_mov, min(PC_data_for_vid{vid_trial,vid_subj,PCsPlotNow(j)}(TimePoint,[1:n_Markers]*3-2)));
            y_lim_min_mov = min(y_lim_min_mov, min(PC_data_for_vid{vid_trial,vid_subj,PCsPlotNow(j)}(TimePoint,[1:n_Markers]*3-1)));
            z_lim_min_mov = min(z_lim_min_mov, min(PC_data_for_vid{vid_trial,vid_subj,PCsPlotNow(j)}(TimePoint,[1:n_Markers]*3)));
        end
    end
    
    
    Space_sides_x   = (x_lim_max_mov-x_lim_min_mov)/2;%/2;
    Space_sides_y   = (y_lim_max_mov-y_lim_min_mov)/2;%/2;
    Space_zmax      = (z_lim_max_mov-z_lim_min_mov)/20;
    Space_zmin      = (z_lim_max_mov-z_lim_min_mov)/40;
    
    x_lim_max_mov = x_lim_max_mov + Space_sides_x;
    x_lim_min_mov = x_lim_min_mov - Space_sides_x;
    y_lim_max_mov = y_lim_max_mov + Space_sides_y;
    y_lim_min_mov = y_lim_min_mov - Space_sides_y;
    z_lim_max_mov = z_lim_max_mov + Space_zmax;
    z_lim_min_mov = z_lim_min_mov - Space_zmin;
    
    
    
    
    if only_ExtremVis == 1
        fprintf('\n        Only Extrem position visualization is selected in "movie_selfmade pca"!')
    else
        Title_vid = [Title,' - ','PM',num2str(PCsPlotNow(1)), ' - PM', num2str(PCsPlotNow(end))];
        Movie_filename = fullfile(PathVid,Title_vid);
        writerObj = VideoWriter(Movie_filename);
        open(writerObj);
        fprintf('\n        Video is being made - The "Data" - Matrix contains %d rows',ende_video);
        h1=figure('name',Title_vid,'Position',[10,10,120*PC_per_figure_movie*dimension_video,700*(1+eigenvaluemovie/2)]);
        h1.Color = 'w';
        
        % Initialize vector for Eigenvalue movie!
        if eigenvaluemovie  == 1
            all_eigs = 1; % 0 only selected EVs are displayed, 1 see below, many! (all plottet?)
            if all_eigs == 0
                AddPM   = PCsPlotNow; % Display only PM-activity of video PCs
            elseif all_eigs == 1
                AddPM   = 1:min(15, length(EVactivity_TrialSubj_PC_vid{vid_trial,vid_subj}(1,:))); % Display frst 20 eigenvalues, or less if less available
            end
            barplot_vec = zeros(ceil(ende_video/skipFrames),length(AddPM));
        end
        rotCtr = 1;
        
        %% ****** 2D Video ******
        mbprogress = msgbox('Video Progress: 0%%');
        for TimePoint =1:skipFrames:ende_video % Start of video plotting
            set(findobj(mbprogress, 'Tag', 'MessageBox'), 'String', sprintf('Video Progress: %d%%', round(TimePoint/ende_video*100)))
            figure(h1)
            for j = 1:PC_per_figure_movie          % ****** Loopstart PC per figure       ******
                % ****** 2D Video ******
                if dimension_video == 2
                    % ****** Sagittal plots with Coloring ****** (x-z plot)
                    subplot(2+1*eigenvaluemovie,PC_per_figure_movie,j)
                    for PlotLine = 1:nr_plot_lines % x-z plot
                        plot(PC_data_for_vid{vid_trial,vid_subj,PCsPlotNow(j)}(TimePoint,ColorOptionsCell{1,PlotLine}*3-2),... % x
                            PC_data_for_vid{vid_trial,vid_subj,PCsPlotNow(j)}(TimePoint,ColorOptionsCell{1,PlotLine}*3-0),... % z
                            ColorOptionsCell{2,PlotLine}, ... % Marker/Linestyle
                            'MarkerFaceColor',ColorOptionsCell{3,PlotLine}, ...
                            'MarkerSize',     ColorOptionsCell{4,PlotLine})
                        if PlotLine == 1
                            hold on
                        end
                    end
                    hold off
                    xlim([x_lim_min_mov x_lim_max_mov])
                    ylim([z_lim_min_mov z_lim_max_mov])
                    title(['Sagittal PM',num2str(PCsPlotNow(j)), ', AmpFac:', num2str(amplifications_used(PcIdxNow(j)))])
                    %               legend(['time ' ,num2str(i/measurement_frequency),' s']);
                    
                    % ****** Frontal view movie-plots with Coloring ****** (x-z plot)
                    subplot(2+1*eigenvaluemovie,PC_per_figure_movie,j+PC_per_figure_movie) % Eigenvalue option included
                    for PlotLine = 1:nr_plot_lines % x-z plot
                        plot(PC_data_for_vid{vid_trial,vid_subj,PCsPlotNow(j)}(TimePoint,ColorOptionsCell{1,PlotLine}*3-1),... % y
                            PC_data_for_vid{vid_trial,vid_subj,PCsPlotNow(j)}(TimePoint,ColorOptionsCell{1,PlotLine}*3-0),... % z
                            ColorOptionsCell{2,PlotLine}, ... % Marker/Linestyle
                            'MarkerFaceColor',ColorOptionsCell{3,PlotLine}, ...
                            'MarkerSize',     ColorOptionsCell{4,PlotLine})
                        if PlotLine == 1
                            hold on
                        end
                    end
                    hold off
                    xlim([y_lim_min_mov y_lim_max_mov])
                    ylim([z_lim_min_mov z_lim_max_mov])
                    title(['Frontal PM',num2str(PCsPlotNow(j)), ', AmpFac:', num2str(amplifications_used(PcIdxNow(j)))])
                    
                    % ****** 3D Video ******
                elseif dimension_video == 3
                    box on
                    subplot(2+1*eigenvaluemovie,PC_per_figure_movie,[j,j+PC_per_figure_movie])
                    for PlotLine = 1:nr_plot_lines % x-z plot
                        plot3(PC_data_for_vid{vid_trial,vid_subj,PCsPlotNow(j)}(TimePoint,ColorOptionsCell{1,PlotLine}*3-2),... % x
                            PC_data_for_vid{vid_trial,vid_subj,PCsPlotNow(j)}(TimePoint,ColorOptionsCell{1,PlotLine}*3-1),... % y
                            PC_data_for_vid{vid_trial,vid_subj,PCsPlotNow(j)}(TimePoint,ColorOptionsCell{1,PlotLine}*3-0),... % z
                            ColorOptionsCell{2,PlotLine}, ... % Marker/Linestyle
                            'MarkerFaceColor',ColorOptionsCell{3,PlotLine}, ...
                            'MarkerSize',     ColorOptionsCell{4,PlotLine})
                        if PlotLine == 1
                            hold on
                        end
                    end
                    hold off
                    
                    xlim([x_lim_min_mov x_lim_max_mov])
                    ylim([y_lim_min_mov y_lim_max_mov])
                    zlim([z_lim_min_mov z_lim_max_mov])
                    title(['3D - PM',num2str(PCsPlotNow(j)), ', AmpFac: ', num2str(amplifications_used(PcIdxNow(j))), '  (Az=', num2str(az), '; El=', num2str(el), ')'])
                    %               legend(['time ' ,num2str(i/measurement_frequency),' s']);
                    
                    
                    RotVec = [ceil(ende_video/run_throughs):ceil(ende_video/run_throughs):ende_video, ende_video];
                    if TimePoint > RotVec(rotCtr)
                        rotCtr = rotCtr + 1;
                        az = az+15;
                        %                     el = 0;
                        if az >= 360
                            az=az-360;
                        end
                        
                    else
                        % az = az+2;
                        % el = 10;
                    end
                    view(az, el);
                end% Dim 2 or 3 end
                
                if eigenvaluemovie  == 1
                    ax2 = subplot(2+1*eigenvaluemovie,PC_per_figure_movie,[2*PC_per_figure_movie+1, 3*PC_per_figure_movie]);
                    h = rotate3d;
                    h.Enable = 'on';
                    setAllowAxesRotate(h,ax2,false);
                    barplot_vec(TimePoint, 1:length(AddPM)) = EVactivity_TrialSubj_PC_vid{vid_trial,vid_subj}(TimePoint,AddPM);
%                     AddPM
%                     barplot_vec(TimePoint, :)
                    bar(AddPM, barplot_vec(TimePoint, :), 'k'); %, 'k'
%                     
                    xlim([.5, max(AddPM)+.5])
                    set(ax2,'xtick',AddPM)
                    set(ax2,'xticklabel',AddPM)
                    ylim([-80,80])
                    xlabel('PP')
                    ylabel('Relative Amplitude [%]')
                    title('PP Activity')
                    view(0, 90);
                else
                    
                end
                                   box on
 
            end % ****** Loop-end PC per figure  ******
            frame = getframe(h1);
            writeVideo(writerObj,frame);
        end % ****** Loop-end Length of video   ******
        
        close(writerObj)
        close(h1)
        close(mbprogress)
        
    end
    
    
    
    
    %     Figure of extrem postitions
    if VidVis == 1 && ExtPosFig == 1
        posnrs = zeros(2,1);
        
        SepHalf_xy(1) = (x_lim_max_mov-x_lim_min_mov);
        SepHalf_xy(2) = (x_lim_max_mov-x_lim_min_mov);
        
        center_xy(1) = (x_lim_min_mov + x_lim_max_mov)/2;
        center_xy(2) = (y_lim_min_mov + y_lim_max_mov)/2;
        center_z     = (z_lim_min_mov + z_lim_max_mov)/2;
        
        xy_lims(1,1) = x_lim_min_mov;
        xy_lims(1,2) = x_lim_max_mov;
        xy_lims(2,1) = y_lim_min_mov;
        xy_lims(2,2) = y_lim_max_mov;
        
        ann_xy_pos{1} = [center_xy(1)-(SepHalf_xy(1)/2), center_z, SepHalf_xy(1), 0];
        ann_xy_pos{2} = [center_xy(2)-(SepHalf_xy(2)/2), center_z, SepHalf_xy(2), 0];
        
        PlaneView(1) = {'Sagittal '};
        PlaneView(2) = {'Frontal '};
        
        fExtPos(pcL) = figure;
        set(gcf,'numbertitle','off','name',['Extremal Positions  - PMs ',num2str(PCsPlotNow(1)), '-', num2str(PCsPlotNow(PC_per_figure_movie))]);
        for j = 1:PC_per_figure_movie
            posnrs(1) = 1; % First position
            posnrs(2) = (length(PC_data_for_vid{1,1}(:,1))/run_throughs)/2+1; % Second position
            
            HeadMarker = 27;
            if PC_data_for_vid{vid_trial,vid_subj,PCsPlotNow(j)}(posnrs(1),HeadMarker*3-2) > PC_data_for_vid{vid_trial,vid_subj,PCsPlotNow(j)}(posnrs(2),HeadMarker*3-2)
                SepHalf_xy(1) = -SepHalf_xy(1);
            elseif PC_data_for_vid{vid_trial,vid_subj,PCsPlotNow(j)}(posnrs(1),HeadMarker*3-1) > PC_data_for_vid{vid_trial,vid_subj,PCsPlotNow(j)}(posnrs(2),HeadMarker*3-1)
                SepHalf_xy(2) = -SepHalf_xy(2);
            end
            
            % The plots
            for AxesNr = 1:2 % x=1 and y=2
                % Plot sagittal view
                subplot(2,PC_per_figure_movie, j+(AxesNr-1)*PC_per_figure_movie)
                for PosNr = 1:2 % extreme positions
                    for PlotLine = 1:nr_plot_lines % lines as in coloring options
                        plot(PC_data_for_vid{vid_trial,vid_subj,PCsPlotNow(j)}(posnrs(PosNr),ColorOptionsCell{1,PlotLine}*3-(3-AxesNr)) + SepHalf_xy(AxesNr)*(-1)^PosNr,... % x, y
                            PC_data_for_vid{vid_trial,vid_subj,PCsPlotNow(j)}(posnrs(PosNr),ColorOptionsCell{1,PlotLine}*3-0),                                ... % z
                            'o-k', ...%ColorOptionsCell{2,PlotLine}, ... % Marker/Linestyle
                            'MarkerSize',      ColorOptionsCell{4,PlotLine}, ...
                            'MarkerFaceColor', ColorOptionsCell{3,PlotLine}, ...
                            'MarkerEdgeColor','k', ...
                            'Linewidth', LinewidthPlots)
                        if PlotLine == 1
                            hold on
                        end
                    end % Lines to plot loop
                end % Position Nr loop
                
                ann_xy = annotation('doublearrow');
                set(ann_xy,'parent',gca);
                set(ann_xy,'position', ann_xy_pos{AxesNr});
                hold off
                xlim([xy_lims(AxesNr,1)-abs(SepHalf_xy(AxesNr)), xy_lims(AxesNr,2)+abs(SepHalf_xy(AxesNr))])
                ylim([z_lim_min_mov z_lim_max_mov])
                title([PlaneView{AxesNr}, 'PM',num2str(PCsPlotNow(j)), ', AmpFac:', num2str(amplifications_used(PcIdxNow(j)))])
                
                % Disable surrounding axes
                set(gca, 'box','off')
                set(gca, 'xtick',[]);
                set(gca, 'xcolor',get(gcf,'color'));
                set(gca, 'ytick',[]);
                set(gca, 'ycolor',get(gcf,'color'));
            end % Axes loop (1, 2 = x, y)
        end % j loop (PC per figure)
    else
    end % if VidVis == 1 && ExtPosFig == 1
    
    
end
%% ****** Finish PC loop ******

if VidVis == 1 && ExtPosFig == 1
    ExtFigName = ['Extreme Positions - PMs 1-',num2str(PCsPlotNow(end)), '.fig'];
    ExtFigNamePaht = fullfile(PathVid,ExtFigName);
    savefig(fExtPos, ExtFigNamePaht)
    close(fExtPos)
end



end











